/***********************************************************************
*
* busybox uwindow.c -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements  
* windows in the busybox program.
*
***********************************************************************/

#include <types.h>
#include <quickdraw.h>
#include <resources.h>
#include <window.h>

#include "busybox.h"

extern GrafPortPtr      windowList[SHORTINDEX];
extern unsigned int     staggerCount;

#define MainWindowID    0x2000L



/***********************************************************************
*
* drawThisWindow
*
* This routine draws the contents of all the windows.
*
***********************************************************************/
void    drawThisWindow()
{
    DrawControls(GetPort());
}


    
/***********************************************************************
*
* doCloseTop
*
* This routine closes the topmost window.  We do a little work to
* prevent the main window from being closed.
*
***********************************************************************/
void    doCloseTop()
{
    unsigned int    k;
    GrafPortPtr     tempWin;

    tempWin = FrontWindow();
        
    /* Find the window entry, close the window, and zero the entry */
    /* start the count at 1 since we never close the main window */
    for (k = 1; k < NumWindows; k++) {
        if (tempWin == windowList[k]) {
            CloseWindow(tempWin);
            windowList[k] = NULL;
            break;
        }
    }
}



/***********************************************************************
*
* openThisWindow
*
* This routine either opens the specified window or brings it to the top
* if it is already open.
*
* If it is not open, we open it with NewWindow2 invisibly, adjust the window's
* location and then show and select the window.
*
***********************************************************************/
void            openThisWindow(ctlid)
unsigned int    ctlid;
{
    GrafPortPtr     wptr;

    if (!(wptr = windowList[ctlid])) {
        windowList[ctlid] = wptr = NewWindow2(NULL, NULL, drawThisWindow, NULL, 2,
            ctlid + MainWindowID, rWindParam1);
        if (ctlid < Prog1ID) {
            MoveWindow (50 + 8 * staggerCount, 50 + 8 * staggerCount, wptr);
            staggerCount++;
            staggerCount &= 0x0F;
        }
        ShowWindow(wptr);
        SelectWindow(wptr);             
    }
    else SelectWindow(wptr);
}
    

    
/***********************************************************************
*
* setupWindows
*
* Sets up windowList record for use through out the program.
*
***********************************************************************/
void    setupWindows()
{
    unsigned int    k;

    /* Zero out the entries in the window list. */
    for (k = 0; k < NumWindows; k++) windowList[k] = NULL;

    /* Open the main window */
    windowList[0] = NewWindow2(NULL, NULL, drawThisWindow, NULL, 2,
        MainWindowID, rWindParam1);
}
